%feature("docstring") OT::ConstantEvaluation
"Constant evaluation.

.. warning::
    This class is experimental and likely to be modified in future releases.
    To use it, import the ``openturns.experimental`` submodule.

Parameters
----------
inputDimension : int, optional
    Input dimension, default is 1
constant : sequence of float, optional
    Constant value, default is [0]

Examples
--------
>>> import openturns.experimental as otexp
>>> f = otexp.ConstantEvaluation(2, [1.0, 2.0, 3.0])
>>> print(f([5.0, 6.0]))
[1,2,3]"

// ---------------------------------------------------------------------

%feature("docstring") OT::ConstantEvaluation::getConstant
"Constant accessor.

Returns
-------
constant : :class:`~openturns.Point`
    Constant value
"
