find_package(ZLIB)
if(NOT ZLIB_FOUND)
  message(WARNING "No Zlib development support found. Disabling COMPRESS package...")
  set(PKG_COMPRESS OFF CACHE BOOL "" FORCE)
  return()
endif()
target_link_libraries(lammps PRIVATE ZLIB::ZLIB)

find_package(PkgConfig QUIET)
if(PkgConfig_FOUND)
  pkg_check_modules(Zstd IMPORTED_TARGET libzstd>=1.4)
  if(Zstd_FOUND)
    target_compile_definitions(lammps PRIVATE -DLAMMPS_ZSTD)
    target_link_libraries(lammps PRIVATE PkgConfig::Zstd)
  endif()
endif()
