/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>

#include <arch/header.ld>

SECTIONS
{
	SRAM_START(0x00000000)
	BOOTBLOCK(0x00000000, 20K)
	FMAP_CACHE(0x00000000+20K, 2K)
	CBFS_MCACHE(0x00000000+20K+2K, 8K)
	TTB(0x00008000, 16K)
	ROMSTAGE(0x00008000+16K, 40K)

	PRERAM_CBFS_CACHE(0x00008000+16K+40K, 20K)

	STACK(0x0001b000, 4K)
	SRAM_END(0x30000)

	DRAM_START(0x100000)
	RAMSTAGE(0x100000, 2M)
	POSTRAM_CBFS_CACHE(0x300000, 32M)
}
