/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextActiveAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextPageAdjustAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextPageVariableSetElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "page-variable-set");

    public TextPageVariableSetElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public Boolean getTextActiveAttribute() {
        TextActiveAttribute attr = (TextActiveAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "active");
        if (attr != null) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setTextActiveAttribute(Boolean textActiveValue) {
        TextActiveAttribute attr = new TextActiveAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textActiveValue);
    }

    public Integer getTextPageAdjustAttribute() {
        TextPageAdjustAttribute attr = (TextPageAdjustAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "page-adjust");
        if (attr != null) {
            return attr.intValue();
        }
        return null;
    }

    public void setTextPageAdjustAttribute(Integer textPageAdjustValue) {
        TextPageAdjustAttribute attr = new TextPageAdjustAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textPageAdjustValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

