﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace Microsoft.AspNetCore.Mvc.RazorPages;

/// <summary>
/// Specifies that a Razor Page model property should be set with the current <see cref="PageContext"/> when creating
/// the model instance. The property must have a public set method.
/// </summary>
[AttributeUsage(AttributeTargets.Property, AllowMultiple = false, Inherited = true)]
public class PageContextAttribute : Attribute
{
}
