---
title: 2019 Tutorial
---

This tutorial showcases network editing, visualizing traffic data, public transport from OSM, parking, netgenerate, and more!

# Files

- [sumo2019_tutorial.zip](https://sumo.dlr.de/daily/sumo2019_tutorial.zip)

# Video
<a class="no-arrow-link" data-youtube href="https://www.youtube.com/watch?v=UeaeCdLt_1o">Watch the 2019 Tutorial</a>


# Transcription

## Intro
Welcome everyone to this year's SUMO user tutorial. My name is Jakob, I am one of the key developers of SUMO, and today I will tell you a few old and new things about SUMO, about features and how to implement them, starting with a basic scenario and moving on to more advanced features. So as I said, this tutorial is not the first. It's somewhat of a tradition every year at the start of the conference we do a tutorial. And there's something like an unofficial tradition that goes with this tutorial. Every time I put this together, I try to showcase all kinds of new features, features that no one has seen before, and features that even I haven't really tried out. So as in every year, after putting together the tutorial, there's a bit of a scramble to get some things working that weren't actually working or in presentable conditions.
So on the USB drive that you got, you will find the tutorial slides. You will find data files if you want to follow the tutorial, reproduce it afterwards. It might be a bit too fast to follow it in real time all the time. But if you want to follow it, there's also a latest development version of SUMO on that, because for some of the things I'll show you today, you won't get them to work with the latest release of version 1.2.0, so even though the Eclipse release we just heard about is very brand new and exciting, it's already outdated, it's superseded by newer code.
If you go to the SUMO wiki, then there's a tutorial page with a subsection SUMO user conference, and there you should be able to get the 2019 files. Otherwise, just go outside and get another USB drive or something like that. So we don't have a lot of time for the tutorial. I'll try to speak quickly and click very fast. But then after that, there is the "Ask Us Anything" session. So any larger questions you can store until then, and I'll try to answer everything I can. All right.
For a brief outline, we'll start with a very quick scenario generation. How to do that? We'll look at a scenario, at this quickly generated scenario, and look at some warnings that show up and fix those with netedit. Then we're going to look at visualizing not only the cars, but also some aggregated properties about traffic to get a bit of a feel for the simulation scenario. Then I'll show some aspects of public transport and intermodal routing. Then for some, maybe the most exciting part, we'll showcase some visual traffic demand editing, because that's an area where for all the last 17 years, users had to rely on editing XML files manually or generating them with their own scripts. So now the first basically working version of getting demand visually. Then I'll show some features about parking, only very brief, because we have Lara who's going to show off a lot more parking features in the demo session. And then I'll talk a little bit about netgenerate, synthetic network generation. So let's start. To follow, as I said, you need 1.2.0, or maybe better, the latest development version, to run some of the scripts that are part of the tutorial. You also need Python. It really doesn't matter whether you use Python version 2 or 3. Most of the time people may not even know there's a difference anymore. There are some text files you may want to have a good editor for editing those. All right. Let's get started.

## osmWebWizard
When you download SUMO, you have your binary files, and maybe you have some examples. But what you really need to get a simulation running are basically two things. The network, a road network that is loadable by SUMO, and you need traffic definitions. Maybe you need infrastructure, traffic lights, bus stops, all these things. And depending on your data source, it can be quite difficult to put these together. But we provide this tool for you that makes it a lot quicker to get started. It's the OSM Web Wizard, and it uses data from the OpenStreetMap project. Who here doesn't know about OpenStreetMap? All right. You'll figure it out. Basically, it's the Wikipedia of maps. So there's a little tool. Let's see if it works here in the demo. So if you have your sumo folder somewhere, then there's a tools subfolder, and there's the OSM Web Wizard somewhere. If you installed SUMO, then you even have that in your start menu somewhere. So what does this do? If you have an internet connection that's actually working, which I may not have, then it shows you a map where you can pick an area. And then you can also pick some elements of traffic that you want to see, trucks, pedestrians, bicycles, all these things. And let's just continue here. It will look like this. And when you're done selecting all the features of traffic that you want, there's a little "generate scenario" button. And that's it. It downloads data from OpenStreetMap in the background, processes that data, and gives you a basic simulation scenario.

## Generated Simulation
And it even opens up sumo-gui and runs that scenario for you. And what it really generates is a folder with lots of lots of files, all these things that I mentioned, a network, infrastructure, traffic, actually traffic for different modes, so lots of files, and a little bit configuration for running all that. So I'll show you how that looks. You also have this folder, that would be generated, as part of the tutorial files in the folder starting with the number zero. So let's look at that. The folder is called "adlershof_wizard" because this is where we are, and this is the area that I picked. So when you run that, you will have something like this. By the way, apologies for skipping one important note. We will be recording this tutorial. Mostly the screen, my audio, so you should be safe. Laugh all you want. The only thing that I also forgot is to actually start the recording. So it should be recording right now. So again, welcome to the SUMO tutorial. All right. Now, what do we have here? We have a view of a simulation network. Here's the train running, the train station here, and we are here at the German Aerospace Center. This is where you came in. This round building here, this is where we are at the moment. And again, from my understanding, who is unfamiliar with this type of thing? Who really needs explaining about sumo-gui? Great. Then I can be a little quicker about this. So let's run this a little bit. Of course, the cars are very small at this level of zoom. What I like to do is make them a little larger. And as you know, there are tons of things that you can do to make the vehicles look differently. Now, the nice thing is since we are recording this, all the mouse clicks are recorded as well. You can just look at the video and you will know where I clicked. So now we have lots of cars running. That's still a little boring. Let's see how fast they run by just making them a little colored. So let's color the cars according to their speed. That's much nicer. Now we can see the trains. They are blue. They are running really fast. Traffic waiting at intersections is red. We are still not seeing everything there is to see. So let's also make the pedestrians stand out. And now you see this is really an intermodal scenario with lots of pedestrians running around in the streets.
And let's add one more bit of information. Let's color them according to what they are doing, according to their mode. So as you can see, most of those pedestrians are now colored green, which means they are walking around. But there are also some that are colored blue, which means they are using public transport. They are riding in a vehicle. And if we zoom in, we can see this here in a, let's say, abstract representation. They are all sitting in the bus. Of course, this is not exactly how they would sit in the bus. We don't model the internals of the bus, but at least you can see how many there are and which ones there are by clicking on them. So this is one of the new features, by the way, a detailed look at distinct visualization of riding persons. All right.

## Fixing network problems
So this is the scenario, and if you look at that from a very high level, then it looks fine. But let's look at the details a little bit. So when we started the simulation, we got some warnings. This warning is really great. You can't even, it doesn't even fit on the whole line. So it talks about an actuated traffic logic with a very, very long ID and something that's unhappy about missing detectors, has no controlling detectors. And there are other warnings. Some traffic lights actually no this is all, has no controlling detector. And then there are warnings about bus stops that are too short. All right. Let's understand what's going on here. So basically the simulation works fine. We can even click on these warnings and see, oh, this takes us to a very interesting looking intersection. And well, traffic is flowing across those intersections. It doesn't look too bad. It's very little traffic actually. There could be a lot more traffic on this intersection. But somehow the simulation is unhappy. All right. What we also see is lots of these strange lines going on here. These are supposed to be the markings for bicycles passing the intersection. But as you can see, they are not in places where you would expect bicycle markings to be. They are all over the place basically. So well, let's then go to the next step of the tutorial and look at that network in detail. All right. So moving on to the next folder. And just to show you how to get to that place. So we had these warnings about the intersection. If I click on that, I'll jump to the intersection. And now I want to look at that very same part of the network in the graphical network editor. So I'm already in the right place. And I press <kbd>Ctrl</kbd> + <kbd>T</kbd> or the menu button for "Open in netedit", and this is what I see. And already I notice there are some strange looking bicycle lanes running through this intersection or entering this intersection. I can tell from the color that these are supposed to be for bicycles. Also by these little bike symbols actually. So what I think is happening here is that the people that were putting the data into OpenStreetMap, they modeled it in a little strange kind of way. They put some extra edges there where they could have just said, this road has a bicycle lane next to it.
The OSM data model is quite flexible here. They didn't edit in a way that the network importer can easily deal with. So we get a strange intersection. Let's just get rid of that. So I just delete these superfluous edges. And I did this by, you can tell from the recording later, I pressed <kbd>D</kbd> for delete mode, and then I just clicked on those things. And then I recompute the network using the <kbd>F5</kbd> key. And whoops, what is that? There are now strange pedestrian crossings. Those were probably generated for these superfluous bicycle edges. So let's just get rid of those as well. The color tells you that they are basically in an invalid state. So it's a good idea to fix them or delete them. All right. So this already looks somewhat better. Now let's take a look at the, the signal plan. Because that signal plan was built for all those bicycles, with all those bicycle edges in mind. And maybe it's not really in the best state right now. I pressed <kbd>T</kbd> for the traffic light mode. And now I can click on that. And on the left pane I see the signal plan. And yes, it has quite a few phases that, well, they look somewhat superfluous to me. So for example, there's one phase where most of the pedestrian crossings are active. And there's another one of those. And yes, that just doesn't look right. So the easiest thing to do now is to just regenerate the traffic light because we changed the topology.

Now for those that have been using SUMO for some time and they had to deal with traffic lights, there's always the issue of, when do you regenerate, or when should the editor regenerate a traffic light? You change some connections, maybe you don't want to lose all the work you did on editing. So in the current state, the editor is quite conservative. If you delete stuff, it tries to keep as much from your earlier work as possible, which now leads us to the need to manually regenerate the traffic light because that was just a bad guess. So we delete the traffic light. And, now we have to regenerate this. Maybe I have to explain a little thing first. Those warning messages, they were not just for any kind of traffic light, but they were for an actuated traffic light, which means a traffic light where SUMO adds some detectors automatically and the traffic light switches according to detections on those detectors. So it's a smart traffic light. Not just a fixed cycle, but one that reacts to traffic, which is generally a good idea for those automatically generated scenarios because the simulation cannot know what traffic you're going to put in there or what random traffic will do. So those actuated traffic lights, they react smartly to any kind of traffic you put in there. And, well, it's not too bad a guess to make those actuated in larger cities, in Germany at least, upwards of 50% of the intersections have these kind of actuation detectors. So, well, it would be about as bad as making all of them fixed controls. Just traffic runs better. All right.
So what we want to do now is we want to rebuild the traffic light here as an actuated traffic light. So, first of all, I go to the inspect mode button <kbd>I</kbd>, click on that intersection and reconfigure this as a traffic light. And then due to something that is probably going to change, I have to click again. And now I get this extra little field here where I can control the type of traffic light. This field is only available for traffic light nodes. So I'll switch this to "actuated", and now, let's go to traffic light mode again and look at that new signal plan. As you can see, it's much shorter than the one before. And something you may not have noticed before, some of these phases, they actually have extra attributes. Just a quick question. Who of you has worked with these actuated traffic lights in SUMO? All right. Quite a few. So here you control the minimum and maximum duration, for these actuated phases. Of course, the phases for the yellow light and the phases for where everyone has the red light, they are not actuated. They have a fixed duration. But the major green phases, they have an actuated duration. And if you look very closely, you can see that there are two extra columns. And I think I should put a heading line in here too. To really show what those columns are. One is for assigning a name. Basically arbitrary human readable name to that phase, which may make it easier to understand what's going on with the traffic light. At least easier than with just having a running index from 0 to 12 or whatever. And the other column is for assigning the index of a follow-up phase. Because it may happen that you want to model traffic lights with branching transitions. And then you really need to put explicitly what is the phase that comes after a certain phase. So this is what this new column is for. If you have questions about that, then ask me after the tutorial. Or in the "Ask Us Anything" session. Alright. So now we have this intersection fixed. There's one thing left to explain. But first I'll save this and show it in the simulation to you. Alright.
So I save the network (<kbd>Ctrl</kbd> + <kbd>S</kbd>), and I reload the simulation that was still open. And yay! Most of the warnings are gone. So... There's one warning for another intersection. But this one is fixed. But again, what were these warnings actually about? They were about controlling detectors. So maybe it would be good to see those. To do that, you can set an extra option in the SUMO configuration. And I'll show you real quick what that is. So... Among all these files, as most of you probably know about, there's the configuration that opens the simulation. I'll just add another option. And let's look at that again. And now suddenly we see all these detectors that are actually responsible for controlling the traffic light. And we see one more unfortunate thing. The code that places these detectors, it always puts them on the first lane that's entering the intersection. So if you have, for some reason, very short edges before the intersection, it doesn't work too well. So let's fix that as well. At least for this intersection. So there's a quick fix for this. As you can see in this little line, there's one intersection. We just turn this into a geometry point. And we're good. But now we did something dangerous. We changed the network topology. There's actually one less edge now in the network because we joined those. But since we're using WebWizard Generator, we can just regenerate the traffic for the scenario. And there's also a little script for that, which is already generated by the WebWizard. It regenerates everything. But we are on Windows, unfortunately. On Windows, you cannot just write on top of a file that's still loaded in an application. So we have to close the simulation. Rebuild that again. So in case you forgot about that, I also put it in the slides for you. You have to close sumo-gui to regenerate the traffic. All right.

So let's look at that again. Now you can see all the detectors are at a reasonable distance from the intersection. And well, actually, we would have to put in a bit more traffic to really see the effect, because right now, all these phases are running at their minimum duration, probably. And there is no phase being made longer due to the logic of the actuated traffic light. All right. So we got rid of a few warnings. And at the same time, we learned a bit more about actuated traffic lights in SUMO. There are some more warnings that are, well, they are similar but different. So here is one that says for one phase, the detector doesn't really know what to do. And the phase, well, let's look at the phase in the editor real quick. I'll just open it in the right place. It's talking about phase six. That would be this one. And it's a phase where there's only turning movements from the side direction. And all the pedestrians are free to walk. So what could basically happen here is that there's lots of pedestrian traffic. And all these turning cars have to wait. And so the logic of the actuated traffic light, it tries to prevent the situation where the phase is kept open very long. So it says "I don't know really how to do this here with an actuated traffic light". So this is what the warning is about. We could fix this, for example, by saying, in this phase, that's only for turning movements. We forbid the pedestrian movement in these places. And then, of course, they have a real green light. Oh, no, not that one. That one. Those. So that would be one way of fixing this. And the warning is gone. Now, because editing networks is so much fun, let's look at the last warning. Well, this looks to be like a pretty interesting intermodal intersection. And we're going to fix it by doing something that needs to be doing for quite a few intersections from OpenStreetMap. And I'll try to explain for those that may have not been faced with the issue. So the network model in OpenStreetMap, it models these complex intersections through many, many, many smaller intersections that are, in some ways, interconnected. And even this circle here representing one intersection in SUMO was made up of one, two, three, four, five, six, seven, eight, nine intersections in the original OpenStreetMap data file. So there has already been some processing going on here. But apparently it wasn't enough. So I think this should be one intersection here. So how would we fix this in netedit? We enter the selection mode (I pressed <kbd>S</kbd>, you will all know from the recording), and I'm going to merge all these intersections into a single one using the <kbd>F7</kbd> key. So now we have one. And while I'm at it, I can just repair some other things here. We talked about short edges, which are unfortunate. Now what else do we have? We have here an edge, an extra edge, which is actually just a footpath, as I know from experience. But here in this place, it's set up for bicycles, which leads to lots of interesting connection topology on the intersection. Let's just prevent the bicycles from driving here. So this is one of the many properties for an edge you can edit. And while we're at it, just let's move the geometry around a little bit to make this look a little bit more realistic. So one thing that's quite important when you look at intersections in detail is what are the geometries not only of the intersection, its center and its shape, but also what are the points where edges enter the intersection. And you can edit those very easily with netedit. So let's do one more thing after we change the permissions here. Let's reset all the connections and recompute them, because if we don't, we have lots of strange connectivity going on here. So let's just reset all that and recompute it. And also while we're at it, let's regenerate the traffic light. Oh, it looks okay, I guess.

All right. So joining junctions, an important concept for fixing OpenStreetNet networks. Oh, and what do I have to do? What do I have to do? Absolutely regenerate the traffic, because I fixed the topology by joining junctions and thereby deleting edges. So you know the drill.
How can we know whether a traffic light uses a fixed or actuated controller? This type of information is not present in the OpenStreetMap data. So right now, it's one of the parameters you put into the network conversion script where you say, by default, all intersects are either fixed or actuated. And then afterwards, manually, you could reassign the types. But there's no way for the importer to know. So, yeah. I mean, this may change because they are changing all the time. People are putting new data into OpenStreetMap. Hopefully, they'll put this type of information in there also. But so far, they haven't.
You're right. But then again, people put lots of really detailed data in there that they certainly don't find printed on the road. And they somehow manage to do this anyway. So, we could maybe do this. We could also add data. So, now, as you can see, I've loaded the simulation. Still not happy. All right. I know what's going on here. The connections are pretty weird at this intersection. So, as you can see from here, there's actually an extra lane for turning movements. But it's only used for moving onto this edge here, which is actually a service edge where buses can drive. So, it's not totally strange, but it's still not the way this should be. So, let's just fix this. All right. That's much better. So, that was key <kbd>C</kbd> for the connection mode, and then a few clicks to fix those connections. Ah, no warnings. I'm happy now. All right. So much for that. Now, when we run the simulation, of course, there will be new warnings about these bus stops that are too short. But this is easy to fix. You just, well, actually, I'll show you. I'll show you. All right. So, let's look at some bus stops. So, here, the intersection is strangely elongated, and there was not enough space for the bus stop. And another instance of a very short edge where the bus stop didn't fit on. And something where... I don't even know why the bus stop is so short there. So, fix this really quick, and then we can finally have a network without warnings. I talked about manipulating the positions where the edges enter the intersection. So, I do that here very carefully. And this will make the intersection much smaller, and then there's space for the bus stop. And, well, maybe I should show the bus stops. That would make them much easier to edit. So, I'll load those. <kbd>Ctrl</kbd> + <kbd>A</kbd> loads the infrastructure files. So, let's edit those as well. Does this look right to me? Yes, it looks right. This looks also much nicer now. And there was another bus stop somewhere. Which one was it? Maybe this one. Doesn't look too bad, actually. Let's just make this a little larger. All right. Of course, there are menus for saving all these things. But I'll just use the hotkeys, which you will find on the recordings. <kbd>Shift</kbd> + <kbd>Ctrl</kbd> + <kbd>A</kbd> and <kbd>Ctrl</kbd> + <kbd>S</kbd>.
All right. Now we have big stops. And finally, no more warnings when running the first few seconds of the scenario. Ta-da! Great. All right. So, these were the first list of things that I wanted to show you for editing networks in netedit. Of course, these were not terribly important things. They are not scenario-breaking things. But often, it pays to look at the small details, look at the warning messages, and see what's going on there. Because it might be a problem eventually. Of course, then you can just look at where the jam develops and you know there's the problem. All right. Moving on to the next part of the tutorial. Let's visualize some traffic data.

## Visualizing Traffic Data
So, of course, the simulation, it's visualizing traffic. You see the vehicles. What more is there to see? Maybe you want to see some aggregated data. Maybe you want to see where all the vehicles have actually gone. Where did they start? Where did they go? And for a long time, this was surprisingly awkward to do in SUMO. So, we made this a little easier. Of course, you still need some aggregated output files. But then you can show them in the simulation. So, how do we do this? I prepared something for you. So, to get certain types of outputs, you still have to change configuration and load some other files that configure outputs. So, here in this SUMO configuration, we are not only loading the shapes and the stops. We're also loading this edge data XML file, which basically says, well, save some data for the edges and save it for all the simulation at once. And, as you can see, as you might not have known, you can now also store data for the pedestrians. This is new here, this detect person definitions. So, when we run the simulation, it's going to record these files here. Again, let's look at what those file names. Here it says to record this, in this file, edgeData_vehicles. And when you run the simulation, this is the file that you get. One for vehicles, one for pedestrians. And now, we have our simulation. And now we can load this edge data for visualization. Let's, well, let's actually load the bare network. So, just, you can load the network by itself. For a very clean look. And now, let's show the data that was recorded. So, there's this new menu item here, "Open EdgeData". I started the simulation, and then I closed it real quickly, and it overwrote the file. So, well, now I have to run it.

Sorry for that. But it gives me the pleasure of showing you a little bit more about what you get. So, of course, you can run sumo in batch mode, which is usually a bit quicker. Since recently, it also tells you in the beginning what version is actually running. So, you can see this is 280 commits past the last release of version 1.2.0. And we'll also store that in the output files. Should be done about now? Yes. All right. We'll attend to these messages in a little bit. But for now, we get some nice statistics. We see how many vehicles there were, and how many persons, and what they all did. They walked, and they rode, and some of them, they missed the bus, quite literally. But now we have our files, and we can look at those. So, of course, everything has a hotkey. This one is <kbd>Ctrl</kbd> + <kbd>U</kbd>. And then at least it tells you that it found a number of attributes. Things like density, and traveltime, waitingTime, all these things, but it doesn't show them yet. So, this you have to configure in the visualization settings for the streets. We color them by edgeData. And let's color them by the number of vehicles that drove on that street, well, actually the number that entered the street. Alright, we have to configure the colors that we want. So, this does this automatically. It just scans the whole data range. And so, the edges with the most traffic, they had 242 participants. But actually, the low numbers, they're not of interest to us, -1 means there was no data. So, let's do a little another rainbow. Let's just show edges with at least 1 vehicle on them, or let's say with at least 3 vehicles on them. All right, so this is another way to reconfigure these colors with a new little switch. And now, we can see at least that this was the main venue for traffic in the simulation. And there was a little bit traffic at the outside. But maybe we also want to see the numbers. And I'm happy to tell you that we can. There's this little control. Well, this is usable when we zoom in. It's not very usable when we zoom out. But there's a button for that. So, let's make the text size stay the same. So, at least it's not so much a visual clutter. And now, we can really see the numbers. 191 vehicles on this edge, for example. So, this is one of the new exciting features where SUMO can help you to look at your data. And of course, you can look at all the other values that were in there, like, for example, the waiting time on selected edges.

All right, any questions for that? No, ask me later. Of course, you could have loaded the pedestrian data in the same way. On these slides, I've shown you what that would have looked like. And you can already see that this is from the pedestrian because the network is much denser. They're walking on all these little edges where cars cannot go. And here you have those relevant controls for getting the numbers and not getting them too big. All right.

## Visualizing Trajectories
Another thing that may be useful to visualize, is trajectories, a little bit more microscopic detail about vehicles. Of course, SUMO can write out these trajectories, it's the FCD-output (floating car data), but some care must be taken if you want to, for example, get a plot of only the speeds along a certain network element, along a sort of stretch of edges. So one of the new features that we got here is the output filtering with this new option where you select network elements that shall only record FCD data. And then there's a little tool that you can use to plot these trajectories according to various qualities. You could plot speeds versus accelerations. In this case we plotted the x value versus the speed, which is a nice proxy for, well, position along a stretch of road. So now we basically already see the places where the vehicles usually were braking and waiting. These are intersections. I'll show you which edges I used in the network. And actually how I got them. So this is again netedit. And as you saw from the slide, I loaded some edges here from this file. And how did I get them? Well, by selecting edges in netedit using the select mode. For example, like this, and then just saving the selection to a file. So this is easy. Also, if you want to investigate one intersection, you can just select the edges, the relevant edges, and then you get nice plots for that intersection. So this is one of the new little tools to go with all those about 100 other little tools that are not easy to find unless you already have a good idea that there could be something valuable to look for. So the SUMO tools folder is pretty full. And there are some gems inside. All right. 

## Public Transport
Let's talk about public transport. The scenario that we saw, it already came with public transport. You notice those little persons riding in the buses, and trams. And I want to explain how that came about, because the traffic mostly was random. But the public transport, it was data based. So OpenStreetMap does contain the position of all the public transport stops. And it also knows about public transport lines connecting those stops. So that's pretty good data already. All that's missing is a schedule that tells you, well, at this time this stop and then so many minutes later the other stop. Well that's pretty easy to get if you have a simulator. You just let the bus drive in the simulation and record the stopping times. That gives you a very basic schedule. Of course you still don't know the real starting times, the relative times, the absolute times when the first line, this or that line started serving the first stop. So this is something that you have to fix. But if you at least want the lines right and being served by buses then you can make use, or actually the wizard makes use of this `ptlines2flows.py` script in the background and generates a bus schedule. And well in version 1.2.0 it throws all the buses in there, regardless of whether they're lines running by day or lines running by night. But if you use the latest development version it already figures out that the night lines don't run at the day. So you have less superfluous buses for you. And then the other nice thing about the public transport facilities are that those persons, they're defined in terms of I want to go, I want to travel from here to there. And there's a little intermodal router in there that determines whether that makes sense to walk or to use a sequence of public transport rides to reach the destination in the fastest way. That all happens automatically in the background. So what you see here is intermodally routed person traffic. Partially pedestrian, partially by bus. All right.

## Adapting Public Transport
But as we saw before some persons missed the bus. What happened there? Well, this public transport scenario was built for one hour of traffic, which also meant in these settings the buses only run for one hour. So if you missed the bus, it's really gone. There's no bus ever coming to pick you up. So this is one of the real reasons here why this happens. If we reconfigure the demand building script in a way where the buses run half an hour longer, then everybody catches the bus. So this is one possible solution. I can show you real quickly where that is. So there's this build script. Depending on whether you run the wizard on Linux or Windows, you get a batch file with the appropriate quotation marks and etc. So here at some point, the public transport data from OpenStreetMap is being imported. And there's an end time given. So the scenario runs to second 3600. And in the early version, the public transport also runs to 3600. If you change this number, then it keeps running. And everybody who misses the bus can still catch the next one. So then you can still ask, how do I figure this out? How do I determine what's actually happening in this scenario? And I want to look with you at the simulation real quick, to see how that works. So first of all, let's get an error message. Let's get it real quick. Up here is the simulation delay. If you set that to zero, the simulation runs as fast as possible. And you see all the cars driving. And if you look really closely, you also see the person's walking and riding in buses. Very nice. And also riding in the trams. And then eventually you still have persons walking and then I don't want to close I have these warning messages here, "a person aborted waiting at a bus stop" alright so I happen to know that this ID implies that the person starts in the simulation at second 3260 so I'll just run the simulation again up to this point of course what you could also do is look at the input file and you see when this person departs, I'll show you how to do this while the simulation runs. So there's the pedestrian routes and let's just search for ID so there we have it, it's a pedestrian and it departs at time 3260 alright and now the simulation stopped at that time, if you missed it I set the breakpoint this is here <kbd>Ctrl</kbd> + <kbd>B</kbd> and I'll ask the simulation to stop at that time. Alright let's now find that person, alright, what can we find out about this person? We can find out where it's walking, so it's walking to this bus stop here, presumably, but we can find out more, we can show the plan of the person. So this is a quite simple itinerary, the person wants to walk to the stop "Magnusstrasse" and then it wants to get a very specific bus hopefully catching it at time 3494, then riding to the "Abtstrasse" and then walking a little bit so let's see how that works out. So we track that person, well it's not visible from here so let's make it a bit more visible, we select the person and we say let's draw the selected persons in enlarged size, so this guy is bigger now - well let's make it even bigger - alright so one person out of many, and it's being followed. So well that doesn't look too bad but look here's already the bus coming and there's a oh just missed the bus... don't you hate it when that happens. So why does it happen here? It happens because in SUMO the persons have their speeds set according to a distribution of speeds, they are not walking like robots at the same speed but actually at the start of the simulation for everybody there's a random number that tells them you are a quick walker you are a slow walker, at the time that those schedules were computed that random number wasn't yet available it was the schedule was built by another application so basically this guy is a very slow walker with a speed factor of 0.78 and so it's just a bit too slow to catch the bus, and there's one other way to fix this - this is why I'm telling you about this - we could also load those person trips directly in the simulation and then the person would know "I'm a slow person, I cannot catch this bus" or maybe "I catch another one" unfortunately this is one of the things that should have been working all the time but it's only working in the development version because even in the simulation that special number was being ignored until quite recently, so if you have the development version you can use the public transport that only runs one hour and only very few people will actually miss the bus because they're really unlucky waiting at traffic lights, well I guess that isn't too unrealistic. People do really miss the bus occasionally. All right so that's what I wanted to tell you about public transport data now on to the next exciting part: public transport editing.

## Visual Demand Editing
I actually opened up a traffic file for you and most of you know how tedious that would be to edit, it's a several megabytes of very detailed things, you need to put the edges in there and the stops and all that stuff so that's really hard to do without extra tooling, well, it's still hard even with tooling if you have a to do it manually but at least for small examples you can so let's uh show how that works. I actually have all xml files open with netedit so that just goes to show what I typically do. All right, so as you can see there's a new super mode a new big button for editing demand in netedit and it gives you lots of new tools here in the toolbar and one of them is for creating a new route - press <kbd>R</kbd> for routes - and there you could click them as a list of consecutive edges, which would be still pretty tedious so let's not do that let's use non-consecutive edges and let's just define the route from here to there. Yay! So that's the fastest route according to the assumptions taken here, you could also place intermediate points here and then it would just join them all together so I press <kbd>Enter</kbd> and now we have this nice route, wasn't that easy, all right while we're at it, just also define a new vehicle type that's the type mode so i can create new types or copy existing types and then define a new name for them and set all kinds of parameters and then set even more parameters because there are lots of parameters for types and then let's create a flow for this I press the <kbd>V</kbd> button for vehicles and I select type flow and then I have to click on this route and there I have it, let's set some parameters, let's say we color this differently that makes it instantly recognizable and we want 300 vehicles per hour, actually why did this change the color?, well to be fair all this demand editing this is one of the things that were partially done after the release of version 1.2.0 and in the frantic weeks when putting together this tutorial so a lot of this stuff is still bleeding edge and there are patches to come and also features to come so the color was somewhat changed I don't know, well you will you will notice this demand editing is still a bit rough around the edges but with more users and more feedback it can only grow better. All right let's save that and let's look at what we just have created, so this would have already have been pretty tedious to put together manually the route the type and the flow, now to use this in the simulation of course we have to change the configuration file so that a new file is being used and now I'm using a preset here to actually let's not use this let's run some traffic, all right, here we have these new vehicles great. It's a flow and they're running along with the regular traffic, ending here at the DLR. All right, so this is a first look at the capabilities of visual demand editing. We could also, let's spice this up, let's open a demand file. Let's open the passenger trips. And hope it doesn't crash. Yes, and suddenly the network is full of cars. And what you now cannot see, but you will be able to see this in the future, some of these edges, they have lots of traffic. So here, if you click that, you see overlapped elements. There are several trips starting on that edge. Not so many here. And we're probably going to space these out along the edge just to make it more visible to see that there's more than one. And of course, it's still not quite clear what are useful operations if you want to edit lots of traffic at the same time. So, for example, if you want to shift traffic from one area of the network to another area, maybe it would be better to aggregate them. Let's say to define traffic zones and then reassign this individual traffic back to the zones and just change the numbers between the zones. We're still thinking about how best to support the user in that. All right. So much for demand editing. Q: "Can this be used to modify a public transport schedule?" Yes, it does already support stops. We'll look at that in the next part. But I don't think it's still where we want it because public transport editing, let's say, is a special case. You really want to look at a sequence of stops and see how the times align. And here, you can click on the stop elements, but it's not, for example, it's not a nice tabular layout for that. So I think we need more tooling. Yes? Q: "Can netedit be used to define persons?" I was coming to that.

## Visual Demand Editing - Outlook
So what remains to be done for the demand editing? There are quite a number of bugs that need fixing. We had to change quite a bit about the architecture of the network editor to accommodate the new mode, or even changes that go down to the level of how do we render objects because suddenly we have these big objects, routes that maybe span the whole network and we don't want to render all of that all the time or it gets slow. So we had to do quite some deep changes and this makes it hard to move quickly because we need to be careful to not break too much stuff. So we need a lot of bug fixing still. We need to have better ways of dealing with overlapping objects in the editor and we need to find good ways to edit big datasets in a way where they stay manageable. And there is also one important feature still missing. You cannot at this time edit persons graphically. Persons are a bit more complex than vehicles because they have one more elemental layer. They have these plans with different items and these plans again have their attributes. So the new thing, the person flow that's already working, you still have to create it manually. But at least now we have a person flow. So I'm quite happy about that. For about five or six years we wanted to have this. COMMENT: "We used a python script to generate pedestrian flows" Yes, yes. A workaround for something that should have been there from the beginning actually. But yes. So you can get person flows. Actually let's show a person flow. So this is how the code looks like. Here it just defines a trip very abstractly from one edge to another and the allowed modes are implicitly walking and optionally public transport. This is from the DLR to the train station. And when you look at that, you will see that some of the persons in the flow will actually use the bus and others will use the tram according to their time of departure. So they are not forced to all do the same thing.
So the flow should be pretty obvious. And they're all queued here at the bus stop. Some of them take the bus, and some of them will take the tram when it comes. In order to make the scenario visually more interesting, I doubled the service rate of the buses and trams. So there's not so much bus traffic actually going on. Oh, that was the tram. You saw it. All right. So this is the person flow. Have fun. All right. Next step, a look at parking.

## Parking
This topic is very dear to some of the participants. And there have been also some contributions in that regard. So let's take a look at how to model parking. We load our network. And actually, we also load our flow. Did I put it there? No. Let's copy it over from the previous editing round. And it was there. Just didn't see it. That was because I was looking in the wrong folder. Right. So we have our flow. We see this when we switch to demand mode. And let's say all this traffic going to the German aerospace center, they have to park somewhere. So we add some infrastructure. We add parking places. And for this, we have to switch back to demand mode -> Additional objects, and let's add some parking areas. All right. Let's put one here and put another one here. If you look at the satellite picture there will actually be people parking at that part and if you look closely you will notice that the people parking on this side, they will actually park on the road and in SUMO you can now model this by switching the definition around and let's do a bit more careful placement. So it should start 10 meters in front of the intersection and maybe 50 meters at the end. More like this. Maybe even like this. Right, and the other one is really big. Let's make it that. Negative numbers go from the end of the edge... So now we have two parking zones, I'll give them other IDs to make this more readible, and one more thing: we have to define the roadside capacity, how many cars can actually park there, so I set this here to 3, and for this one, well, I was thinking of a stand-in to a large parking zone that's located here. I could add all these parking spaces. Actually, I'll show you how to do that. But I don't want to add all of them. So I could place lots of spaces here. It shouldn't be necessary to click again. I have to make a note of that. Anyway, you could model this in detail. You could even change the angle of these parking spaces, even though they're just for visualization. But I'm not going to bother with that. Also here they're spacing for 100 vehicles. All right. And I save that, as a new file. And now back to the demand mode. I want this flow to stop at this parking area. So I go to the stop mode. And now I click, careful, now they're trying to stop on this lane. I don't want that. I want them to stop at this element. So I have to select a stop at a parking area. And now they can stop here. And that's already looking pretty good. So I save my demand file. And let's take a look at that in the simulation.

All right. So here we load the new route. And when we look inside, we see that I saved it in the wrong folder. This is what we see. Nope. Curses. Ah, this is why. I saved the stop as part of the route definition. No, I shouldn't have done that. So, again, the stop, it requires clicking on the object or selecting it from a list. So I should have clicked on this flow element here. No. On this vehicle. The other thing is the route. All right. So now let's define the stop as child element of the flow. Actually, you can do both, it depends on what you want to model exactly. But I had this in mind as putting it as a child of the flow. All right. Now it moved there. Great. And of course, we also have to load these new parking areas. Maybe we'll have the wizard to build these configuration files eventually. But maybe we don't need it after all. All right. What do you think will happen when we run this? Will they all get to park? Notice that they're parking on the road, and the bus doesn't come through, but well, there were only three spaces. What shall they do? They wait. You may think that's not realistic, well it isn't, it's a simulation. You have to tell the vehicles about possible alternatives. For example, parking on the other side of the road. Now, to do this, you can define particular elements in SUMO. that tell vehicles, well, if you reach this parking area and it's full, then you can go to this, this, and this alternative parking area. It's quite tedious to define these definitions, but luckily Lara has provided a little tool to generate them automatically. And this tool is, well, it should be, no. Oh, yes, yes. At least it mentions the file. All right, so this is a, because the tool, even the tool needs quite a few of options. This is why I put the call to the tool in an extra file. So it's a tool for using the tool for using the tool. It generates these infrastructure elements that explain how to reroute to another parking area. And obviously it requires the definitions of the parking areas and the network file and then something about how many alternatives shall there be and at what distance and all these, is the status, the level of, or the number of free parking places visible at these alternatives, or do they have to guess and think, well, I could drive there, there might be places. So these are all things that can be controlled with options. And when you run this script, then you get this little file. Well, in this case, it's not too big. You could have written that by hand. But if you have a bigger scenario, then you certainly don't want to write that out by hand. So basically what it tells you is when the vehicles reach a certain edge, the edge of the parking area, and they notice that the parking area is full, then they will reroute to the other parking area. So let's look at that in the simulation. And since I defined this to have 100 parking spaces, there's plenty of space for them. So basically all managed to park. It's not really fair because this parking area is for DLR employees only. So if you had all come by car, you still couldn't have parked there by the hundreds. So it's a little bit of artistic freedom, I guess. All right. So this was a very brief look at parking. And of course, you can do this to model vehicles that circle around the block, around the block, around the block to eventually find a parking area or not if you configure the visibility options in a way where they really have to make a guess at where to go next. And also, this has effects on persons riding in these cars, because maybe the persons want to go somewhere. And if you park somewhere else, well, then they also have to change the way they walk. And where do they get back? Where do they pick up the car? So there are several implications. Most of those are already handled, not all of them. But you'll hear about that, I guess, in the later session. All right. So much for parking. Moving on to the last part of the tutorial, actually.

## Netgenerate
Let's talk a little bit about synthetic networks. So as you may know, among all these applications in the SUMO folder for routing, simulation, demand building, there's also one tool for generating abstract networks called netgenerate. And there are, since the inception of this tool, there have been three basic types of network that you can build with that: grid networks, spider networks, and random networks. Of course, there are tons of parameters you can use to tweak these networks. The grid size, they don't have to be even length, so you can make them rectangular. The number of spokes in the spider and lots of attributes for the random networks. But within the last year, some new options were added to get even nicer random networks, get even nicer synthetic networks. So one thing that was added was the ability for adding turning lanes automatically to these, well, actually to all networks. And there's even some code that makes the lanes line up nicely, which is otherwise pretty hard to get right. And in this option, there was also some randomness added, so you can see not all of these roads have the same number of lanes. And if you want to test, let's say, traffic light algorithms or other kinds of algorithms or disposition maybe where you can work with random networks or synthetic networks, that really helps you to get a bigger range of traffic scenarios. And another thing that you can use to generate really nice looking networks is the new random grid mode. So it's a hybrid of grid network and random network because random networks, well, they have very little structure. They don't look too much like roads. Sometimes it doesn't matter. But visually, they're not very pleasing. But here, the random grid mode, I think it catches rather nicely certain geometric properties of road networks. And then there are also some options to perturb the coordinates even further. So you can have some ups and downs in the network, even in the Z level. But also, to get light offsets from a regular grid. So I am sure there are more sophisticated tools for generating road networks. But you can get already pretty far with the tooling that's already there with netgenerate. And I invite you to try that out. All right. These are all the things I wanted to tell you today. Coming up next is the Ask Us Anything session. So all the questions that you cannot address now, you can ask later. But I think we also have now time for, let's say, 10 more minutes of questioning. So if you have any about this tutorial or topics related to the tutorial, go ahead.

## Q&A

Q: "Just one question about the OSM WebWizard: Can you change the projection?"   
A: Well, the WebWizard tool itself, it always projects to UTM coordinates. But you can, well, I'll show you. Yes, you can. So the answer is yes, you can change that. This wizard generates lots of files. And among them is this netconvert configuration. netconvert is the tool for, yeah, all right. So by default, when importing OpenStreetMap, it always switches to UTM. But you can add an extra option like this. And then you can put in a PROY string. So like a definition string from the PROY. Right. So I'm not sure. It comes from the PROY library. So it might even work with an EPSG code. Yeah.

Q: "Is there a way to retake the road after some time of parking? You modulate the road to park and then you can take it from there. Like park for one hour or 15 minutes and then we take another road?"   
A: Yeah, sure. The stop doesn't have to be the last element in the route. You can stop in between and then go somewhere else. So definitely. And there's also, this is quite a relevant issue for these parking areas. If you park on the road, then it's pretty clear how to continue. You just keep on driving. But if you park next to the road as here, then you actually have to find space on the road. So if it's jammed, you might have a hard time entering back into the traffic. So there may be a case where the stop has conceptually ended, so the duration is passed. But the car still has to stand there and wait for a space, for a gap in traffic if it's very jammed.

Q: "Is parking at an angle supported?"   
A: Sure. Let's do this here real quick. Go to this mode, Inspect Mode. And there is the angle parameter here somewhere. I have to make it less dense or you won't see it. So let's say that's a place for 12. So it's still a bit too dense, but you get the idea. You can make this angular, like this. It would be still in the wrong direction, so you would have to park in reverse. Yeah. Then just take another angle. But mostly this is optics. Because you can get arbitrary densities for this roadside parking. It doesn't check for physical overlap, just to make it more convenient to add lots of spaces in one little place. You can use this to model a big parking facility with a very small space that's just actually the entrance, but then there's, 500 parking spaces behind that. You just put this little thing on the road.

Q: "Is it possible to visualize aggregated traffic that varies over time?"   
A: Yes. Thanks for asking. I wanted to show that anyway. So let's take a look here. So you have to save edge data in a dynamic way. By default, the first definition I showed you, it just saves the data aggregated over the whole simulation. But if you aggregate it with a different frequency, let's say a 15-minute interval, then you get a time resolved edge data. And when you load that into the simulation, you can show these time varying values. I'll just regenerate this real quick. All right. So. this has ran and now we can look at the time varying data let's say of the density... so here the density is low and now we just run the simulation and if you look carefully you see the values changing over time according to the time values that were stored.

Q: "Is it possible to have this kind of data, given that we record them during the simulation, is it possible not to visualize them, but have them around them? Like the last time it's having their attention time"   
A: Well, technically, we're not so far away from that actually. It's not yet there, but it should work to just show the latest aggregation values. Yeah, remind me again, I'll put that out. Just put in an issue at GitHub, then I'll know. All right?

Q: "Can heterogeneous person attributes be defined? Can different person models be used at the same time?"   
A: Yeah, sure. So the persons, they use the same type attribute as the vehicles, and you can also put in the type distribution. If you define this distribution, they can draw from the distribution. For example, but also all other things that you can define in the type. So the person flow, then every element of the flow would pick a new type from the distribution. No, the model is a global setting. You have to switch one or the other model. We're planning to add more pedestrian models also by coupling pedestrian simulators. And maybe then we'll also open up the possibility of having different models simultaneously. But for now, the most important use case is having one model throughout. So for now, it's a global switch.

Q: "Is it possible to edit elevation data with netedit?"   
A: Sure, so let's take a look at that here, so there are several ways you can do this for example for intersections you can just set the set level explicitly but there's also a feature in the move mode you can switch this to elevation we'll start with showing you the elevation value, and then we'll show you the position value and then we'll show you the values and then actually you can move geometry points up and down I'll switch the coloring to make this more understandable. So let's say I color this by the inclination and now you see I moved the point of one geometry and it changes the angles at that point so this is one way of adding elevation but typically for larger scenarios you want to load the elevation data from someplace else but for small scenarios well you can edit it this way and of course you have access to these values numerically as well I mean there are these Z coordinates right here so you can add them to every geometry point if you care about exact numbers.

Q: "Will elevation and grades be considered when simulating persons?"   
A: Well, yes and no. Yes it's taken into consideration because the distance is actually longer if you have to go horizontally and upwards but there is yet no model that says they walk proportionally slower because it's up the stairs or something, so what you could do of course is chop the edge into bits and and set a different maximum speed there but I guess what we really need is a better pedestrian model that takes such things as inclination into account.

Q: "Will elevation and grades be considered when simulating vehicles?"   
A: Yes and no. It's the same answer as before because there's one model KraussPS where the slope actually factors into the acceleration but the default model ignores slope. Also the other model, the KraussPS model does have artifacts because it does not consider that the acceleration that a vehicle allows depends also on the speed. So if the road is very steep then the vehicle won't start. Whereas in reality it has a lot of power in a low gear and it would start eventually. It would just drive up the steep slope in a low gear and this is not considered in this KraussPS model, which tells you something. It tells you that we haven't done a lot of detailed simulation of mountainous areas or we would have cared about these things.

Q: "Is lateral acceleration included in the floating car data output?"   
A: Surprisingly you are not the first person to ask me this today. It will be put into the pretty much next commit.
