# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.virtualenclaves import VirtualEnclavesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestVirtualEnclavesMgmtTransitHubOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(VirtualEnclavesMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_transit_hub_get(self, resource_group):
        response = self.client.transit_hub.get(
            resource_group_name=resource_group.name,
            community_name="str",
            transit_hub_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_transit_hub_begin_create_or_update(self, resource_group):
        response = self.client.transit_hub.begin_create_or_update(
            resource_group_name=resource_group.name,
            community_name="str",
            transit_hub_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "provisioningState": "str",
                    "resourceCollection": ["str"],
                    "state": "str",
                    "transitOption": {"params": {"remoteVirtualNetworkId": "str", "scaleUnits": 0}, "type": "str"},
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_transit_hub_begin_update(self, resource_group):
        response = self.client.transit_hub.begin_update(
            resource_group_name=resource_group.name,
            community_name="str",
            transit_hub_name="str",
            properties={
                "properties": {
                    "state": "str",
                    "transitOption": {"params": {"remoteVirtualNetworkId": "str", "scaleUnits": 0}, "type": "str"},
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_transit_hub_begin_delete(self, resource_group):
        response = self.client.transit_hub.begin_delete(
            resource_group_name=resource_group.name,
            community_name="str",
            transit_hub_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_transit_hub_list_by_community_resource(self, resource_group):
        response = self.client.transit_hub.list_by_community_resource(
            resource_group_name=resource_group.name,
            community_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_transit_hub_list_by_subscription(self, resource_group):
        response = self.client.transit_hub.list_by_subscription(
            community_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
