/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobQueue;
import org.apache.turbine.services.schedule.TurbineSchedulerService;
import org.apache.turbine.util.Log;

public class TurbineNonPersistentSchedulerService
extends TurbineSchedulerService {
    public void init(ServletConfig config) {
        if (this.getInit()) {
            return;
        }
        try {
            Log.info("TurbineNonPersistentSchedulerService init()....starting!");
            this.scheduleQueue = new JobQueue();
            TurbineNonPersistentSchedulerService turbineNonPersistentSchedulerService = this;
            if (turbineNonPersistentSchedulerService == null) {
                throw null;
            }
            this.mainLoop = new TurbineSchedulerService.MainLoop(turbineNonPersistentSchedulerService);
            Vector jobProps = TurbineResources.getVector("scheduler.jobs");
            Vector<JobEntry> jobs = new Vector<JobEntry>();
            if (!jobProps.isEmpty()) {
                int i = 0;
                while (i < jobProps.size()) {
                    String jobName = (String)jobProps.elementAt(i);
                    String jobPrefix = "scheduler.job." + jobName;
                    if (TurbineResources.getString(jobPrefix + ".ID", null) == null) {
                        throw new Exception("There is an error in the TurbineResources.properties file. \n" + jobPrefix + ".ID is not found.\n");
                    }
                    int sec = TurbineResources.getInt(jobPrefix + ".SECOND", -1);
                    int min = TurbineResources.getInt(jobPrefix + ".MINUTE", -1);
                    int hr = TurbineResources.getInt(jobPrefix + ".HOUR", -1);
                    int wkday = TurbineResources.getInt(jobPrefix + ".WEEKDAY", -1);
                    int dayOfMonth = TurbineResources.getInt(jobPrefix + ".DAY_OF_MONTH", -1);
                    JobEntry je = new JobEntry(sec, min, hr, wkday, dayOfMonth, jobName);
                    jobs.addElement(je);
                    ++i;
                }
            }
            if (jobs != null && jobs.size() > 0) {
                this.scheduleQueue.batchLoad(jobs);
                this.restart();
            }
            this.setInit(true);
            Log.info("TurbineNonPersistentSchedulerService init()....finished!");
        }
        catch (Exception e) {
            Log.error("Cannot initialize TurbineNonPersistentSchedulerService!: " + e);
        }
    }

    public JobEntry getJob(int oid) throws Exception {
        JobEntry je = new JobEntry(-1, -1, -1, -1, -1, null);
        je.setPrimaryKey(new NumberKey(oid));
        return this.scheduleQueue.getJob(je);
    }

    public void addJob(JobEntry je) throws Exception {
        this.scheduleQueue.add(je);
        this.restart();
    }

    public void removeJob(JobEntry je) throws Exception {
        this.scheduleQueue.remove(je);
        this.restart();
    }

    public void updateJob(JobEntry je) throws Exception {
        try {
            je.calcRunTime();
        }
        catch (Exception e) {
            Log.error("Problem updating Scheduled Job: " + e);
        }
        this.scheduleQueue.modify(je);
        this.restart();
    }
}

