/* SPDX-License-Identifier: MIT */
/*
 * Copyright 2021 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors: AMD
 *
 */

#ifndef __DC_LINK_DPIA_H__
#define __DC_LINK_DPIA_H__

#include "link_service.h"

/* Read tunneling device capability from DPCD and update link capability
 * accordingly.
 */
enum dc_status dpcd_get_tunneling_device_data(struct dc_link *link);

/* Query hot plug status of USB4 DP tunnel.
 * Returns true if HPD high.
 */
bool dpia_query_hpd_status(struct dc_link *link);

/* Decide the DP tunneling settings based on the DPCD capabilities
 */
void link_decide_dp_tunnel_settings(struct dc_stream_state *stream,
			struct dc_tunnel_settings *dp_tunnel_setting);

#endif /* __DC_LINK_DPIA_H__ */
