//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/databox/armdatabox/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ServiceServer is a fake server for instances of the armdatabox.ServiceClient type.
type ServiceServer struct {
	// NewListAvailableSKUsByResourceGroupPager is the fake for method ServiceClient.NewListAvailableSKUsByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAvailableSKUsByResourceGroupPager func(resourceGroupName string, location string, availableSKURequest armdatabox.AvailableSKURequest, options *armdatabox.ServiceClientListAvailableSKUsByResourceGroupOptions) (resp azfake.PagerResponder[armdatabox.ServiceClientListAvailableSKUsByResourceGroupResponse])

	// RegionConfiguration is the fake for method ServiceClient.RegionConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	RegionConfiguration func(ctx context.Context, location string, regionConfigurationRequest armdatabox.RegionConfigurationRequest, options *armdatabox.ServiceClientRegionConfigurationOptions) (resp azfake.Responder[armdatabox.ServiceClientRegionConfigurationResponse], errResp azfake.ErrorResponder)

	// RegionConfigurationByResourceGroup is the fake for method ServiceClient.RegionConfigurationByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	RegionConfigurationByResourceGroup func(ctx context.Context, resourceGroupName string, location string, regionConfigurationRequest armdatabox.RegionConfigurationRequest, options *armdatabox.ServiceClientRegionConfigurationByResourceGroupOptions) (resp azfake.Responder[armdatabox.ServiceClientRegionConfigurationByResourceGroupResponse], errResp azfake.ErrorResponder)

	// ValidateAddress is the fake for method ServiceClient.ValidateAddress
	// HTTP status codes to indicate success: http.StatusOK
	ValidateAddress func(ctx context.Context, location string, validateAddress armdatabox.ValidateAddress, options *armdatabox.ServiceClientValidateAddressOptions) (resp azfake.Responder[armdatabox.ServiceClientValidateAddressResponse], errResp azfake.ErrorResponder)

	// ValidateInputs is the fake for method ServiceClient.ValidateInputs
	// HTTP status codes to indicate success: http.StatusOK
	ValidateInputs func(ctx context.Context, location string, validationRequest armdatabox.ValidationRequestClassification, options *armdatabox.ServiceClientValidateInputsOptions) (resp azfake.Responder[armdatabox.ServiceClientValidateInputsResponse], errResp azfake.ErrorResponder)

	// ValidateInputsByResourceGroup is the fake for method ServiceClient.ValidateInputsByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	ValidateInputsByResourceGroup func(ctx context.Context, resourceGroupName string, location string, validationRequest armdatabox.ValidationRequestClassification, options *armdatabox.ServiceClientValidateInputsByResourceGroupOptions) (resp azfake.Responder[armdatabox.ServiceClientValidateInputsByResourceGroupResponse], errResp azfake.ErrorResponder)
}

// NewServiceServerTransport creates a new instance of ServiceServerTransport with the provided implementation.
// The returned ServiceServerTransport instance is connected to an instance of armdatabox.ServiceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServiceServerTransport(srv *ServiceServer) *ServiceServerTransport {
	return &ServiceServerTransport{
		srv:                                      srv,
		newListAvailableSKUsByResourceGroupPager: newTracker[azfake.PagerResponder[armdatabox.ServiceClientListAvailableSKUsByResourceGroupResponse]](),
	}
}

// ServiceServerTransport connects instances of armdatabox.ServiceClient to instances of ServiceServer.
// Don't use this type directly, use NewServiceServerTransport instead.
type ServiceServerTransport struct {
	srv                                      *ServiceServer
	newListAvailableSKUsByResourceGroupPager *tracker[azfake.PagerResponder[armdatabox.ServiceClientListAvailableSKUsByResourceGroupResponse]]
}

// Do implements the policy.Transporter interface for ServiceServerTransport.
func (s *ServiceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServiceClient.NewListAvailableSKUsByResourceGroupPager":
		resp, err = s.dispatchNewListAvailableSKUsByResourceGroupPager(req)
	case "ServiceClient.RegionConfiguration":
		resp, err = s.dispatchRegionConfiguration(req)
	case "ServiceClient.RegionConfigurationByResourceGroup":
		resp, err = s.dispatchRegionConfigurationByResourceGroup(req)
	case "ServiceClient.ValidateAddress":
		resp, err = s.dispatchValidateAddress(req)
	case "ServiceClient.ValidateInputs":
		resp, err = s.dispatchValidateInputs(req)
	case "ServiceClient.ValidateInputsByResourceGroup":
		resp, err = s.dispatchValidateInputsByResourceGroup(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServiceServerTransport) dispatchNewListAvailableSKUsByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListAvailableSKUsByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAvailableSKUsByResourceGroupPager not implemented")}
	}
	newListAvailableSKUsByResourceGroupPager := s.newListAvailableSKUsByResourceGroupPager.get(req)
	if newListAvailableSKUsByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataBox/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/availableSkus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdatabox.AvailableSKURequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListAvailableSKUsByResourceGroupPager(resourceGroupNameParam, locationParam, body, nil)
		newListAvailableSKUsByResourceGroupPager = &resp
		s.newListAvailableSKUsByResourceGroupPager.add(req, newListAvailableSKUsByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListAvailableSKUsByResourceGroupPager, req, func(page *armdatabox.ServiceClientListAvailableSKUsByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAvailableSKUsByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListAvailableSKUsByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAvailableSKUsByResourceGroupPager) {
		s.newListAvailableSKUsByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (s *ServiceServerTransport) dispatchRegionConfiguration(req *http.Request) (*http.Response, error) {
	if s.srv.RegionConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegionConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataBox/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regionConfiguration`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatabox.RegionConfigurationRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.RegionConfiguration(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegionConfigurationResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServiceServerTransport) dispatchRegionConfigurationByResourceGroup(req *http.Request) (*http.Response, error) {
	if s.srv.RegionConfigurationByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegionConfigurationByResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataBox/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regionConfiguration`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatabox.RegionConfigurationRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.RegionConfigurationByResourceGroup(req.Context(), resourceGroupNameParam, locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegionConfigurationResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServiceServerTransport) dispatchValidateAddress(req *http.Request) (*http.Response, error) {
	if s.srv.ValidateAddress == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidateAddress not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataBox/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateAddress`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatabox.ValidateAddress](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ValidateAddress(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AddressValidationOutput, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServiceServerTransport) dispatchValidateInputs(req *http.Request) (*http.Response, error) {
	if s.srv.ValidateInputs == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidateInputs not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataBox/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateInputs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	raw, err := readRequestBody(req)
	if err != nil {
		return nil, err
	}
	body, err := unmarshalValidationRequestClassification(raw)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ValidateInputs(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ValidationResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServiceServerTransport) dispatchValidateInputsByResourceGroup(req *http.Request) (*http.Response, error) {
	if s.srv.ValidateInputsByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidateInputsByResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataBox/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateInputs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	raw, err := readRequestBody(req)
	if err != nil {
		return nil, err
	}
	body, err := unmarshalValidationRequestClassification(raw)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ValidateInputsByResourceGroup(req.Context(), resourceGroupNameParam, locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ValidationResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
