// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:
// SPDX-FileCopyrightInfo: Copyright © DUNE Project contributors, see file LICENSE.md in module root
// SPDX-License-Identifier: LicenseRef-GPL-2.0-only-with-DUNE-exception
//
// WARNING
// This file is automatically generated by gaussradau.mac! Don't edit by hand!
#ifndef DUNE_GEOMETRY_QUADRATURE_GaussRadauLeft_HH
#define DUNE_GEOMETRY_QUADRATURE_GaussRadauLeft_HH

#ifndef DUNE_INCLUDING_IMPLEMENTATION
#error This is a private header that should not be included directly.
#error Use #include <dune/geometry/quadraturerules.hh> instead.
#endif

#include "numberfromstring.hh"

namespace Dune {

  /************************************************
   * Quadraturerule for 1d line
   *************************************************/

  template<typename ct, int dim>
  class GaussRadauLeftQuadratureRule;

  template<typename ct>
  using GaussRadauLeftQuadratureRule1D = GaussRadauLeftQuadratureRule<ct,1>;

  template<typename ct>
  class GaussRadauLeftQuadratureRule<ct,1> : public QuadratureRule<ct,1>
  {
  public:
    /** brief The highest quadrature order available */
    constexpr static int highest_order = 30;

  private:
    friend class QuadratureRuleFactory<ct,1>;
    GaussRadauLeftQuadratureRule (int p);
  };

  //! internal Helper template for the initialization of the quadrature rules
  template<typename ct>
  struct GaussRadauLeftQuadratureInitHelper {
    static void init(int p,
                     std::vector< FieldVector<ct, 1> > & _points,
                     std::vector< ct > & _weight,
                     int & delivered_order);
  };

  template<typename ct>
  void GaussRadauLeftQuadratureInitHelper<ct>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    case 0 :
      delivered_order = 0;
      _points.resize(1);
      _weight.resize(1);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 1.0);
      break;

    // order 1,2
    case 1 :
    case 2 :
      delivered_order = 2;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.25);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.6666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.75);
      break;

    // order 3,4
    case 3 :
    case 4 :
      delivered_order = 4;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.8449489742783178098197284074705891391965947480656670128432692567250960377457315026539859433104640234);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.3764030627004672750500754423692807946676125699817591630990918731319177672928523603738927935248711045);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.3550510257216821901802715925294108608034052519343329871567307432749039622542684973460140566895359765);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.5124858261884216138388134465196080942212763189071297257897970157569711215960365285149960953640177843);
      break;

    // order 5,6
    case 5 :
    case 6 :
      delivered_order = 6;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0625);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9114120404872960526044538562305438031142706680772504345688363048300235125731899032747806923838984214);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.2204622111767683752754784720371859890529167281230873116876396332191458306523173431813869747371986422);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.2123405382391529439747581101240003766519199414890261591145475508607692831081746308640139445069166552);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.3288443199800597439442892210727968317490234075874455536546030877312606057631737874914764364720579267);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.5905331355592652891350737479311701059480951047194376920309018585949214900329211801469196488234706375);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.388193468843171880780232306890017179198059864289467134657757279049593563584508869327136588790743431);
      break;

    // order 7,8
    case 7 :
    case 8 :
      delivered_order = 8;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.03999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9428958038854823178068788074458843787649220544012498356721917070690653217979268354138861831801572631);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.1437135607912259413234122198541102271589229617318809184244815352000477933742653045394234927685913557);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.1397598643437805521520870811248802332616219774127744950757664058160257420698344355865098450735723893);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.2231039010835707444025602182285893596530132769666542171491954357318447595238752822393854332837929434);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.7231569863618761723199540023143748588891108303049695316505579511688786603162919632274584714359488691);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.28135601514946206019217265034065989120000299266737412219813168211940937087419012854107836846850562);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.4164095676310831799433023313370827513065673601032283598237061581682524980381689879943677225325437006);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.3118265229757412540818549115766405219880607686340907422281913469486980762276692846801127054791100807);
      break;

    // order 9,10
    case 9 :
    case 10 :
      delivered_order = 10;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002904443936136988704613522974964763885677664394036593149115822206008312261073264473647011675707760947);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.02777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9601901429485312576591933099066668322957373457716148380535922517950352543738256931454977409168154327);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.1007941926267404201046003778745677818586739544978990469020905175031896616185019326523859081070179564);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.09853508579882642612349889788775269038051356954828979943626418694343487404001393811382476449539206683);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.15982037661025548327288999189811797479611146812876839180378402272111432088446591677960283187954084);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.8019865821263918274642078632047037639618136411662111207916708231727912882713534973402270785858446056);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.2084506671559538694797031913713231216677075046880940122344846434185750632010718140854202072910519794);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.3045357266463639054853851762788328386059984450013516409148027388674711861631761331260749534539964475);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.2426935942344849580799139577934448339939675840621020934694189186061539713876707499244320986309746931);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.5620251897526138559949874799947711474832097257852598735309427264939946698789034655471027352752241744);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.2604633915947874912851147032847685099057617108453586778124441199731892051305118087803811763136367531);
      break;

    // order 11,12
    case 11 :
    case 12 :
      delivered_order = 12;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007745183829698636545636061266572703695140438384097581730975525882688832696195371929725364468554029193);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.02040816326530612244897959183673469387755102040816326530612244897959183673469387755102040816326530612);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9706835728402151080279497230868350896262696074362850722130893160550639617583342212513690516348156304);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.07449423555601031793324878020916692097532644942393942434007237049841313043955906688474729498373429045);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.07305432868025888514812603418031798894382758045771674727553292034335479754747175618566051998641260845);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.1196137446126562028935387403847763008302627238892853476612432820588170328039983753965707678098696572);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.8519214003315157081500231475040207877697512251914055385874053581984016139091216781936306023382524239);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.1591021157336507408724352172349341821081630163278709547082536480846529383453687327524900611444633129);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.2307661379699454990831166398843545481628578566777045838330518303634518694260467143147997884572256323);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.1904749368221155769029691739380627618671473914712524715596097410083045379273763891870770560020639449);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.6630153097188457009029470279192242948024312499715266528774370319263086494872159391475908588263455174);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.2123518895029778041991540195751041223560385606946763943251267338610614147090378494828338349159860945);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.441328481228449867918606658194478059925631711034592174444252773882649877102578921676179947987717418);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.2235549145072832347496744768212210179855108377848121420995717755091591090399657087452605769806173937);
      break;

    // order 13,14
    case 13 :
    case 14 :
      delivered_order = 14;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002904443936136988704613522974964763885677664394036593149115822206008312261073264473647011675707760947);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.015625);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9775206135612875018911745004291549400778260927643996101407157239412414242418781198561934406230013095);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.05725440737212859967117686425977936825057099397716932914168114853242340872092305631760230041130854427);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.05626256053692214646565219103231117577976551474462308357244279169739421434833830334809817873295303859);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.092679077401489639270364486349647736830932563674935858313467408965379128989721699937903158856790959);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.8853209468390957680903597629324853729222701754680280546110102650484316601686228018917616112512735336);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.1248239506649324816289346467565124312159878101369501620465085111501266363843363392424861677155123433);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.1802406917368923649875799428091817845420606208054701553226255552798179881679575210257100429476812829);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.1520653103233925644878716457001354421902137069080648805811724927448463625325070164171434664138434795);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.7342101772154105315232106083066100025630031185943901059793203132469449813827574545335273993579018924);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.1735073978172506401143379592110741293229628009936786196599092457283690261775051724258224098007456587);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.3526247171131696373739077701712412028080218830572747823992093386338329349089188367412000944987530987);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.188258772694559278286064630720786335118640532533949995543333201250716465965606978691283022057567494);
      _points[7] = DUNE_NUMBER_FROM_STRING(ct, 0.5471536263305553830014485576523488546403859278991475413080093454856701301148602959368425659217691773);
      _weight[7] = DUNE_NUMBER_FROM_STRING(ct, 0.1957860837262467965412497670020645570706915917752511547139279916281389712293997369677594747442315208);
      break;

    // order 15,16
    case 15 :
    case 16 :
      delivered_order = 16;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.01234567901234567901234567901234567901234567901234567901234567901234567901234567901234567901234567901);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.982220084852636548186794898962320938733511601761499566334392168321240752424216993402735723249677561);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.04535725246164145850644674920795090340044910382256608423236014041761080705247011291369808019791001464);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.0446339552899698507331210218583077615235771330099676095516167511431071451132089417478769694427720403);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.07382700952315769290979424990076684192644119748373204166495034257132170235826067178423603914263698819);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.9086763921002060439962585419254586468929595242554323312331298273652046995208401247646196210786180932);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.1002766490122759787105825452084585374837100645139951717640162083073491273282749948425325106489951269);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.1443662570421455714852185202282149697135218394604248395904329066503718245154436216327021789030911811);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.1235946891022965261806198974844998620884284109101835335540040960997860637405727093530324964819711671);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.7856915206043692416424587324183296773255702824775234091862673808591419017359106772087095035558392945);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.1431933481786155855733528188760054645853142508187793084336149756313973598558725153845647136386781611);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.2868247571444305189486862397490926585531162090545734410269295070347862040652774612810232153945976245);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.1584218878352189891690004248211828904282803901135082813370203191442722409397377362074389726296125592);
      _points[7] = DUNE_NUMBER_FROM_STRING(ct, 0.6280678354167276975691460395173707553318999366225193221323614587502696491405131872248705142273454069);
      _weight[7] = DUNE_NUMBER_FROM_STRING(ct, 0.1688469834879647929018621198957803825501226794932222463313217885924663693432674422816562201729896321);
      _points[8] = DUNE_NUMBER_FROM_STRING(ct, 0.4548133151965733509677277700467869448670199439462947750625170586994072352492948750904034506186470334);
      _weight[8] = DUNE_NUMBER_FROM_STRING(ct, 0.1741365013864832970359955155930094385249082238316676536703664502234506503691981382204952880748606714);
      break;

    // order 17,18
    case 17 :
    case 18 :
      delivered_order = 18;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004647110297819181927381636759943622217084263030458549038585315529613299617717223157835218681132417516);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.009999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9855875903511234513671732591891867605882552689434219139292493208718611241653995510560493069627278988);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.03680850274337924946552564703952257250633407560110190885784111690017778477215458793270183849421941181);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.03625781288320946094116430076808145207587112284186378615204960856440268445424725950892430803303695375);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.06014833527874081575865526135099759590938724369183571272716692583091329962913008482323531114050148899);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.9256126102908039553640818140440014149190230867152648015732003972549800762097657190320875705450169663);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.08218800636846073785084083445387855020451656194507156599834064798783462171005161946359655246906025996);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.1180789787899987001922851119947352236928794145512961380870233486716910894342914014436902135496614535);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.1021350659395003377778943361115165106736257210286962005068043553499340322306121690246726114965883931);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.8238833438370047181368242539274314135886139520306941260653516628281521076851947966928410833783966496);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.1195967158571898566882859830801363758258364741540254585528364764210946139183141897137094066862003184);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.2371769848149603853173066928532744670764888172962619220088994091653832785191521320229569635701171547);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.1340974189205893480292772376310295553451252092166458466844053839661648602000224960759896073212453487);
      _points[7] = DUNE_NUMBER_FROM_STRING(ct, 0.6903324200723621829403795327705159511836109155028740754264075614582089368761546507541276227740725424);
      _weight[7] = DUNE_NUMBER_FROM_STRING(ct, 0.1453050824164591555734315389815310253381621189272259396591735666935382783811527201352568817760678677);
      _points[8] = DUNE_NUMBER_FROM_STRING(ct, 0.3818827653047059753607702483964955197193325953602086524939606944414221222571517883134253635138762796);
      _weight[8] = DUNE_NUMBER_FROM_STRING(ct, 0.1529296438622113105081377377003979801780786241826203904279240012042738305695686747214466554361694378);
      _points[9] = DUNE_NUMBER_FROM_STRING(ct, 0.5380295989189890651168568913194356918927669320212724790007001020070564751354848064390554624099362061);
      _weight[9] = DUNE_NUMBER_FROM_STRING(ct, 0.1567912286134691883479514236509898340189339712527769765855075256460686785889934581093911351799474732);
      break;

    // order 19,20
    case 19 :
    case 20 :
      delivered_order = 20;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.008264462809917355371900826446280991735537190082644628099173553719008264462809917355371900826446280991);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.988082386567584403090254413041014023969972152741625141979724006955586480282060464479065044623011125);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.03046254890606556735360916344416515441920593612889634378768602325986918684909318284948512089071412454);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.03002903216148649704306435763440794069465484353742079153109599483012027857151955489540349737972766236);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.04992304095398403194787673479012341784951435295822716798886200345394064771188529448902933415752225152);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.9382679281228518744773706328057498585471279196380978678152992024969945773221744501139764469102888345);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.06851684106660112815507694029022108631584560319435756477685101885640953683767976717173664864587875312);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.09828901220985322965120102159023201853188232392706395246734326269440241414786137920675831210414931387);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.08565880960332991824335632452114911543009060544673768448218195768393830581589904069386788764433631681);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.8528885503569297595724005644201804978662286380940702194287132906740209399339138553299454744945661568);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.1010815542700122091749658771329642516494277755940245416341823725777740925226297436637027602819852004);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.1990210789631011548620536983827574753269977377400846616882581446047631433554426401296405366408468264);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.1144330619244883122008416155631972831221456389832920628771016872588315039886167750369068708206089062);
      _points[7] = DUNE_NUMBER_FROM_STRING(ct, 0.7388403239915437597339483419451542768013642838620432746964478689064990027375417996262675556594376508);
      _weight[7] = DUNE_NUMBER_FROM_STRING(ct, 0.12546268884856419732457013381672775718613069695897309262354779249129469297632546407602624370590123);
      _points[8] = DUNE_NUMBER_FROM_STRING(ct, 0.3240555383233348926428494910652385284960047237704642544860587698373743421209691377704544481199982942);
      _weight[8] = DUNE_NUMBER_FROM_STRING(ct, 0.1339335430948420889033190816775717752086008360038592987740894422858598943031122752005614670488956897);
      _points[9] = DUNE_NUMBER_FROM_STRING(ct, 0.6053601531142131570380478949223924977850608463510158023053388436121170679083816014767543736971187973);
      _weight[9] = DUNE_NUMBER_FROM_STRING(ct, 0.1396806665516915225944810978601028731857924475265701484072617959266351875863206717620061077170286754);
      _points[10] = DUNE_NUMBER_FROM_STRING(ct, 0.4632612342843393671269048222881109772188017684333521288398158534833598488582303550669724056089505765);
      _weight[10] = DUNE_NUMBER_FROM_STRING(ct, 0.142582781970503668730002204457496293897708917122417466549062352486438686945627867701305658260682571);
      break;

    // order 21,22
    case 21 :
    case 22 :
      delivered_order = 22;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.006944444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.989981719538319594156975270132195215185208059483783761337830876297223142538554851051885253094427821);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.02562404960363464873401147256755191359698912179586886783614733167396359699140406477146628165245745726);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.02527362039752034975333118646162910191546318234451419946737982100782123486413153541445864844884682208);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.04208606746934048812078982684064078598356207668454606077811004135971778814182424352552804186759516359);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.9479645488728194474164573042270356775528140749416181644444711806566967214871910443747161670323384541);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.05795374014586919637517095413584668388777153128408424542984574266464927148200496692165819750039770507);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.08304161344740514670686537298197258224799489043700742864789645601375671679018635847006293053875439026);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.07278183442699756426127382735286559431255511311081887313664967558148928208419907103707790861347367931);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.8753807748555569262647004127360907707525558699119941437528128079837703940650480909233478784024579154);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.08638531965665428215303288348279335482371411193381952188479961232975350369852446186555482138789619392);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.1691751003771814259694334560943432960560106956817856499813320666127921816819385788328203455244042225);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.09849926741304481732802481898451691715880480601630014213517520121230333584098958189070626683477635742);
      _points[7] = DUNE_NUMBER_FROM_STRING(ct, 0.7771593929561621444921685465426372355882747496725702918356361826383937691630167983849414146483995146);
      _weight[7] = DUNE_NUMBER_FROM_STRING(ct, 0.1089344395130962194243737410114312720559919702231833101252380994924976153392527006073200151967269551);
      _points[8] = DUNE_NUMBER_FROM_STRING(ct, 0.2777967151090320744366786921953890928627635544874086055440220181219102315933254697424818285109646655);
      _weight[8] = DUNE_NUMBER_FROM_STRING(ct, 0.1175015575724929196743169929697715883009119236048689568907922000277105361992896721300643435454773039);
      _points[9] = DUNE_NUMBER_FROM_STRING(ct, 0.659991842085334811766394766102982472268670660179149419652906526261715790387928769066606410356866858);
      _weight[9] = DUNE_NUMBER_FROM_STRING(ct, 0.1240607804020049797015365535394355200719995254498010043949067360502230324581192591300795635289312217);
      _points[10] = DUNE_NUMBER_FROM_STRING(ct, 0.401502720232860816772279286326956409725081247802388848866048868530464346904528768969408858744606104);
      _weight[10] = DUNE_NUMBER_FROM_STRING(ct, 0.1284956690763538880639871267992001336436691476013189170108039583312533699461672093381787487185684594);
      _points[11] = DUNE_NUMBER_FROM_STRING(ct, 0.5318623869104159579168896192422464067147282324490838342957501523971946009589323434649224386109767104);
      _weight[11] = DUNE_NUMBER_FROM_STRING(ct, 0.1307328302760665517190373578715017917195862278509456559330869568319942233737803243379213667092550587);
      break;

    // order 23,24
    case 23 :
    case 24 :
      delivered_order = 24;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.005917159763313609467455621301775147928994082840236686390532544378698224852071005917159763313609467455);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9914609450115725806313355391221601971939095854334222535037420726987696354242378332024901570386923708);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.02185145163395103741442669230253126228354537862132045649291743515926153592140670516392700801272894985);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.02156206316585036090809308308300396163193087033237463382010693450956786493785754057828948353107650017);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.03595120814624776446987687028207407841501895536660169592463294449355425288370779064245312669926985388);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.9555535368445922769745332012144472337586906962110028900086035795656397136033835220419601208036469249);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.04963390344092354299236819387388759872276531452267544246797332700574719345537345645571951255905295405);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.07105789873558898215118984486568470014950675852301765289624007061007562590735710859702939041980089356);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.06255191716557617906688464398784008656184274649282227400711808747510050471677954744690856656060123432);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.8931455091165233423658932295675007374102001856304999724419368874377163856594813185372360302206494126);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.07457547504500010257574593212085472848830959655207242548776306668431488289996654073064815660600252619);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.1454474562350641192097880835943828715140404962604416130384782853000148383526977847419860132619172941);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.08550173023530832123187933725608529010988327742650916870829611194441770373681670809118932944409747882);
      _points[7] = DUNE_NUMBER_FROM_STRING(ct, 0.8078489454701459590089427437713866696172986329784781339626035117036631132615997966722531487360379653);
      _weight[7] = DUNE_NUMBER_FROM_STRING(ct, 0.09518685777981586612737991037293691958788184471208789194562638680044365745312132402614513871070282189);
      _points[8] = DUNE_NUMBER_FROM_STRING(ct, 0.2404011104747729462573974259565796580577935649114620735689777213576880026087471077503722272450185674);
      _weight[8] = DUNE_NUMBER_FROM_STRING(ct, 0.1034803057279385373155662804144384374750427276214146948478010879630533907564801063538733440312738658);
      _points[9] = DUNE_NUMBER_FROM_STRING(ct, 0.704619115737419778377083165623985094060109286689147891948541911948590244816709519376876901230363183);
      _weight[9] = DUNE_NUMBER_FROM_STRING(ct, 0.1102671146442257323455385820995765357020738630479430106311100293991178535583726917255962453649948882);
      _points[10] = DUNE_NUMBER_FROM_STRING(ct, 0.3503993497227450072337082766570194277743468817226962651442804103514355751401337999111439270543466699);
      _weight[10] = DUNE_NUMBER_FROM_STRING(ct, 0.1154444314434977170061018793339061362073895171982322864758099735381130891596922281273366371689249657);
      _points[11] = DUNE_NUMBER_FROM_STRING(ct, 0.5894549187985423175109656494406675881566813048090818245014434041890480317232773850262626782782335785);
      _weight[11] = DUNE_NUMBER_FROM_STRING(ct, 0.1189392738303560156713425945898368420344422709752939545408915255899383006020911343567290538236643372);
      _points[12] = DUNE_NUMBER_FROM_STRING(ct, 0.4690491506871823293710697571031818606754917364983747951650452103277909685645172835640999221802166392);
      _weight[12] = DUNE_NUMBER_FROM_STRING(ct, 0.1206991711438455743154334620642569364828104246227900120795274795682394100041207609623141177050766563);
      break;

    // order 25,26
    case 25 :
    case 26 :
      delivered_order = 26;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.00510204081632653061224489795918367346938775510204081632653061224489795918367346938775510204081632653);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9926353489739106783493085015861776563887942843835539995793105835477302499661054490025836808715547063);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.01885358163494845713873136414594165020975759392510590592315060034299193800069304020789391250755439251);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.01861036501098785143971937784028768844731989720919976200449028134444641611193796918522105104544966762);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.03106100845388573008306645823341460455969559499141094108084012625707654955896377969536296135374710094);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.9616018612603216496231674751358583140821701658636453123875839882017572193085974102596500086533790577);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.04297026772149020154465386554328283974483688526109607883477417143735728532178658495401673766981052349);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.06147554089926898760236661323470064826601469379371128736454911262787526257519781678731859529345190475);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.05430386137218141341336046761449170556749717283973110242510925951515177257930583451532790775304492282);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.907404775300997364717108624561383644110720141345707073676334067647180789268631504575939099602402819);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.06496983436867117390371286857296886542757042851651763549881540867872262529279047866030734246306485196);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.1263051786933105806322854328682561088266184650796652405553038384524855945271314581468883265977601376);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.07481026967656067797526041847298687382328381103405386550842777879482025911405057274802766818691774256);
      _points[7] = DUNE_NUMBER_FROM_STRING(ct, 0.8327489886084422685044775212406428836252662912609022104165030737675518600067382640219022510167169201);
      _weight[7] = DUNE_NUMBER_FROM_STRING(ct, 0.08371486394554313949505113851903285254546037528256798216114894580640831517395702564992236389997285344);
      _points[8] = DUNE_NUMBER_FROM_STRING(ct, 0.2098429717265625144471366675006240677295733863863000682865650028219473094668441359420634556129970228);
      _weight[8] = DUNE_NUMBER_FROM_STRING(ct, 0.0915635010628648270619336510514316864439809227594628152951066579840052366089190074610930288816591208);
      _points[9] = DUNE_NUMBER_FROM_STRING(ct, 0.7413764592942374834102092671773089974754698626082298883428408231757040278651279725026256944884884611);
      _weight[9] = DUNE_NUMBER_FROM_STRING(ct, 0.09826275922649121516230654596477485524374871885835884725402164208061259270491076568978920429932178543);
      _points[10] = DUNE_NUMBER_FROM_STRING(ct, 0.3078989982803983431029580483123302698191088991281347122618493925443269136581261580203722085588643097);
      _weight[10] = DUNE_NUMBER_FROM_STRING(ct, 0.1037248816675878363340414432447055349260953854618612465467764711248264947647953780386198366283149413);
      _points[11] = DUNE_NUMBER_FROM_STRING(ct, 0.6378686027177611995913187017726784411364995511772176333048372109232234314635133853892353518843386822);
      _weight[11] = DUNE_NUMBER_FROM_STRING(ct, 0.1078835503023094256905937230574369840724121681977091473649374022846524089107794784879188404811405312);
      _points[12] = DUNE_NUMBER_FROM_STRING(ct, 0.4155560359786595444957791521890892937047338381892111916976340162321515955161435570436286929170990484);
      _weight[12] = DUNE_NUMBER_FROM_STRING(ct, 0.1106849057497854744658358415102718135678259837364580620549598005910175475300839492981459854834952701);
      _points[13] = DUNE_NUMBER_FROM_STRING(ct, 0.5274156139958822748249053573214027271284512643152623608629393494543600710066456598633123241982380029);
      _weight[13] = DUNE_NUMBER_FROM_STRING(ct, 0.1120946740013538971192073161100760603984472040336255537254011228574590152552906352058191083511396366);
      break;

    // order 27,28
    case 27 :
    case 28 :
      delivered_order = 28;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001738793769767343904495295754345571979559028417229907098604005560663642940295860998223344323190379554);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.004444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9935832392071815431891795359054928211342801600877551156927612300672664543862947608443448780958123031);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.01643219579229676612652142641153073057741290693423739200638154484999854248273452294729310561302604524);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.01622476590139976171877199085899914319709390816531859734586175987707687606413367759488759606181782854);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.02710139002432224716910711840089438470564976679454870725896584731580262535409379031752562837870266878);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.9664985954679868599640360714294275183896092307471576329276780766789933861508405059308741382033136873);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.03755419638025321986648583269569141758805153698961255144076732637991919601646605173770385110166578307);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.05369729993972461646659405657527595508774248615448350245208116515943580662324999237841443862523323363);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.04756479973024044960192386331729517468694216465472046057613808264784485886335468527107776368357517029);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.9190145003180448156075486922600178127723348524133450049217006087220298280346817491821251334462922047);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.0570676017448763765065377912843275486532773680936293313767427911822960640342192529908062097810219568);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.1106571911804844603091283390535104352962371370946732400854945517624619434315473724165586916213335371);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.0659377312524758160931310789717671834328714396438875129556617113002714624562014461183427180565642943);
      _points[7] = DUNE_NUMBER_FROM_STRING(ct, 0.8531951323187862700763398347392008484400305345720243772819514486686862944412743714542539449832626435);
      _weight[7] = DUNE_NUMBER_FROM_STRING(ct, 0.07408976350173362696234102937128255487413805694748258883130522716337536508449919660779818071285032187);
      _points[8] = DUNE_NUMBER_FROM_STRING(ct, 0.184610260556525358026925781387942485290986594488488348550043578240036759408723301454537843222707428);
      _weight[8] = DUNE_NUMBER_FROM_STRING(ct, 0.08142723865191631472436612291392116582120502240478308220490604700601857925394464346640601462002559893);
      _points[9] = DUNE_NUMBER_FROM_STRING(ct, 0.7719157293507420084653559013800570280584222751679494821663909853829601496219459319624363715810794585);
      _weight[9] = DUNE_NUMBER_FROM_STRING(ct, 0.08787443632122384283515522023795954919820258839409278348995177107324231289791167390445951868050365719);
      _points[10] = DUNE_NUMBER_FROM_STRING(ct, 0.2723235471107353145639732720096683033834398314753513399125190504034543468895320600690705980999378579);
      _weight[10] = DUNE_NUMBER_FROM_STRING(ct, 0.0933575729197254540418975518996095015505528049870462214693890052089200962043726360505074761465047243);
      _points[11] = DUNE_NUMBER_FROM_STRING(ct, 0.6787282560110638255976596025869645503426953689901490274844755846471571428880995957367810779605895242);
      _weight[11] = DUNE_NUMBER_FROM_STRING(ct, 0.09781875152255805823677830878766431530678913099926441455902384806443677576510945244842491271878973857);
      _points[12] = DUNE_NUMBER_FROM_STRING(ct, 0.3699633116295960421155194058685667208394969678912820529754722640634305779213746039692319126702381657);
      _weight[12] = DUNE_NUMBER_FROM_STRING(ct, 0.1012075935153092149363516552173900812119855087993622184426068461562271888887057964368860900909478014);
      _points[13] = DUNE_NUMBER_FROM_STRING(ct, 0.5777053426924297421595910124818973041782061237726561210360459286147423731763712353309088285755771095);
      _weight[13] = DUNE_NUMBER_FROM_STRING(ct, 0.1034879801247768777395136608932904389620559700843852088264115370008206803210070375686989446492003508);
      _points[14] = DUNE_NUMBER_FROM_STRING(ct, 0.4732621386601269679462730551871170046239072876000558123399375608157163368239998071928159261631498453);
      _weight[14] = DUNE_NUMBER_FROM_STRING(ct, 0.1046343040738472907154448951529315089864212898285030821173039702063818079329353696896251413221774439);
      break;

    // order 29,30
    case 29 :
    case 30 :
      delivered_order = 30;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = DUNE_NUMBER_FROM_STRING(ct, 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005479717559511785356037513346100187864311860156749039074665184562002349132558225640280695361501975654);
      _weight[0] = DUNE_NUMBER_FROM_STRING(ct, 0.003906249999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999);
      _points[1] = DUNE_NUMBER_FROM_STRING(ct, 0.9943593110274882902424935334205557990339158930118688520320216648617818584242636359510843027964103301);
      _weight[1] = DUNE_NUMBER_FROM_STRING(ct, 0.01444856950840716424575961150167959664768321485447374308786815965237503412236544031701308852051345129);
      _points[2] = DUNE_NUMBER_FROM_STRING(ct, 0.01426945473682577473409936694087075789551933760203186036325030954651888956599628056591711400813026015);
      _weight[2] = DUNE_NUMBER_FROM_STRING(ct, 0.02385111347384286023258796121105761215940712748373347733951249612012262824249209179131707229548989037);
      _points[3] = DUNE_NUMBER_FROM_STRING(ct, 0.9705177013520575133683590152819962908129903869683392223983870064790167903034053568486267341100344935);
      _weight[3] = DUNE_NUMBER_FROM_STRING(ct, 0.0330947543050682173723367824140129988109765140797056057089486775834419651379958009126595489547599592);
      _points[4] = DUNE_NUMBER_FROM_STRING(ct, 0.04729959009416668566195579247573790649444100617985074008802534665652951429767415480867610494865748146);
      _weight[4] = DUNE_NUMBER_FROM_STRING(ct, 0.04199264072248258900350601284912850274175530373827143449384382997141429563265696715138196207857827561);
      _points[5] = DUNE_NUMBER_FROM_STRING(ct, 0.9285870468848411599452160982532650808781270976577256432156829861889351099405380495381492676393374186);
      _weight[5] = DUNE_NUMBER_FROM_STRING(ct, 0.05049783981089195436218504141066416942898549189111011390903678585931367460678472505588559551870946612);
      _points[6] = DUNE_NUMBER_FROM_STRING(ct, 0.09771329932062197336876149533799091973451231441505312828394887199823910603835287454339017423348361128);
      _weight[6] = DUNE_NUMBER_FROM_STRING(ct, 0.05851017655193002851526082850951591652992414137147165348431935555746818051798695168136190985636111654);
      _points[7] = DUNE_NUMBER_FROM_STRING(ct, 0.8701689744464089440287454619057100876822769215286084547311072008596702756828385045903159139024205357);
      _weight[7] = DUNE_NUMBER_FROM_STRING(ct, 0.06596284996653406672246151063058849160747151189927306232812579118709032621265417948009199088684731203);
      _points[8] = DUNE_NUMBER_FROM_STRING(ct, 0.1635690393943898760244409143458168033855949483720078662210225769787010095148705137084095993368174563);
      _weight[8] = DUNE_NUMBER_FROM_STRING(ct, 0.07277777261010112143531914999678279515995507797472250238664229606324038347926030123455318661603847499);
      _points[9] = DUNE_NUMBER_FROM_STRING(ct, 0.7975072449498959524317800116797695573970854161142183816901802286406130127161712094362254868592345368);
      _weight[9] = DUNE_NUMBER_FROM_STRING(ct, 0.07889346090210101014257961013735628556027751692815831358281184285722704118272376932178081897027333611);
      _points[10] = DUNE_NUMBER_FROM_STRING(ct, 0.2423352609686572880029257222597146820593113812409063518254618742048074468087699354179079370191486055);
      _weight[10] = DUNE_NUMBER_FROM_STRING(ct, 0.08424819892496124501819105207923275942561890638984801295494652596992252939263197128583747944314191086);
      _points[11] = DUNE_NUMBER_FROM_STRING(ct, 0.7133939137424729400159739545156035875368164816717741252722827402235235856326626073451638972112504038);
      _weight[11] = DUNE_NUMBER_FROM_STRING(ct, 0.0887923963763697559481752588801875527471665581288797954926123946185668633418713757400843776997412092);
      _points[12] = DUNE_NUMBER_FROM_STRING(ct, 0.3309848049700401234613043609468604348754672020142472763579249855944450800334866947086959686179464198);
      _weight[12] = DUNE_NUMBER_FROM_STRING(ct, 0.09248089074433267978323239376056093439894591473240448144120626047437788156837996046854633882875631641);
      _points[13] = DUNE_NUMBER_FROM_STRING(ct, 0.6210613113530219618934709908572261485745472556669887099875179336024807875463320325286487031409688204);
      _weight[13] = DUNE_NUMBER_FROM_STRING(ct, 0.09527914712767754441311796762044089051519985174582994892126109353070075332923324694354921353229351015);
      _points[14] = DUNE_NUMBER_FROM_STRING(ct, 0.4261108390933141193285461447624735606660073732125682857503471734338354175189815310094521824810589853);
      _weight[14] = DUNE_NUMBER_FROM_STRING(ct, 0.09715954485578392167168809787195218347038559646446468604327985098793468776901949385191763241792479535);
      _points[15] = DUNE_NUMBER_FROM_STRING(ct, 0.5240576915367651394274110079841503184572579520857465856538068426663859869433985544832075814370361246);
      _weight[15] = DUNE_NUMBER_FROM_STRING(ct, 0.09810439411951584113359872112683931079624727231765316882558463956680375546394372476401978438057097569);
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }


  template<typename ct>
  GaussRadauLeftQuadratureRule<ct,1>::GaussRadauLeftQuadratureRule (int p)
      : QuadratureRule<ct,1>(GeometryTypes::line)
  {
    //! set up quadrature of given order in d dimensions
    std::vector< FieldVector<ct,1> > _points;
    std::vector< ct > _weight;

    int deliveredOrder_;

    GaussRadauLeftQuadratureInitHelper<ct>::init(p, _points, _weight, deliveredOrder_);

    this->delivered_order = deliveredOrder_;
    assert(_points.size() == _weight.size());
    for (size_t i = 0; i < _points.size(); i++)
      this->push_back(QuadraturePoint<ct,1>(_points[i], _weight[i]));
  }

} // namespace Dune

#endif // DUNE_GEOMETRY_QUADRATURE_GaussRadauLeft_HH
